<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';

// Handle form submit
if (isset($_POST['add'])) {
    $first_name = mysqli_real_escape_string($conn, $_POST['first_name']);
    $middle_name = mysqli_real_escape_string($conn, $_POST['middle_name']);
    $surname = mysqli_real_escape_string($conn, $_POST['surname']);
    $phone = mysqli_real_escape_string($conn, $_POST['phone']);
    $next_of_kin = mysqli_real_escape_string($conn, $_POST['next_of_kin']);
    $relationship = mysqli_real_escape_string($conn, $_POST['relationship']);
    $next_of_kin_phone = mysqli_real_escape_string($conn, $_POST['next_of_kin_phone']);
    $paid_amount = mysqli_real_escape_string($conn, $_POST['paid_amount']);
    $paid_date = mysqli_real_escape_string($conn, $_POST['paid_date']);
    $expiry_date = mysqli_real_escape_string($conn, $_POST['expiry_date']);
    $payment_status = mysqli_real_escape_string($conn, $_POST['payment_status']);
    $notes = mysqli_real_escape_string($conn, $_POST['notes']);

    // Get next member_number
    $getMax = mysqli_query($conn, "SELECT MAX(member_number) AS max FROM members");
    $next_member_number = 1;
    if ($getMax && $row = mysqli_fetch_assoc($getMax)) {
        $next_member_number = (int)$row['max'] + 1;
    }

    $sql = "INSERT INTO members 
    (first_name, middle_name, surname, phone, next_of_kin, relationship, next_of_kin_phone, paid_amount, paid_date, expiry_date, payment_status, notes, member_number) 
    VALUES 
    ('$first_name', '$middle_name', '$surname', '$phone', '$next_of_kin', '$relationship', '$next_of_kin_phone', '$paid_amount', '$paid_date', '$expiry_date', '$payment_status', '$notes', '$next_member_number')";

    if (mysqli_query($conn, $sql)) {
        echo "<script>alert('Member added successfully!'); window.location.href='members_all.php';</script>";
    } else {
        echo "<div class='alert alert-danger'>Error: " . mysqli_error($conn) . "</div>";
    }
}

include 'includes/header.php';
?>


<h1 class="mb-4"><i class="fas fa-user-plus"></i> Add New Member</h1>

<form method="post" class="row g-3">
    <div class="col-md-4">
        <label>First Name:</label>
        <input type="text" name="first_name" class="form-control" required>
    </div>
    <div class="col-md-4">
        <label>Middle Name:</label>
        <input type="text" name="middle_name" class="form-control">
    </div>
    <div class="col-md-4">
        <label>Surname:</label>
        <input type="text" name="surname" class="form-control" required>
    </div>

    <div class="col-md-4">
        <label>Phone:</label>
        <input type="text" name="phone" class="form-control">
    </div>
    <div class="col-md-4">
        <label>Next of Kin:</label>
        <input type="text" name="next_of_kin" class="form-control">
    </div>
    <div class="col-md-4">
        <label>Relationship:</label>
        <input type="text" name="relationship" class="form-control">
    </div>
    <div class="col-md-4">
        <label>Next of Kin Phone:</label>
        <input type="text" name="next_of_kin_phone" class="form-control">
    </div>

    <div class="col-md-4">
        <label>Paid Amount:</label>
        <input type="number" step="0.01" name="paid_amount" class="form-control">
    </div>
    <div class="col-md-4">
        <label>Paid Date:</label>
        <input type="date" name="paid_date" class="form-control">
    </div>
    <div class="col-md-4">
        <label>Expiry Date:</label>
        <input type="date" name="expiry_date" class="form-control">
    </div>

    <div class="col-md-4">
        <label>Payment Status:</label>
        <select name="payment_status" class="form-select">
            <option value="OK">OK</option>
            <option value="Due">Due</option>
            <option value="Expired">Expired</option>
        </select>
    </div>

    <div class="col-12">
        <label>Notes:</label>
        <textarea name="notes" class="form-control"></textarea>
    </div>

    <div class="col-12">
        <button type="submit" name="add" class="btn btn-success"><i class="fas fa-save"></i> Add Member</button>
        <a href="members_all.php" class="btn btn-secondary">Cancel</a>
    </div>
</form>

<?php include 'includes/footer.php'; ?>
